package w83b.w83bOperacionesPaso.w83bMantenimientos.w83bArbitros;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.lang.StringUtils;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.hssf.util.Region;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

import w83b.w83bBeans.W83bArbitrosBean;
import w83b.w83bBeans.W83bUsuarioXLNetsBean;
import w83b.w83bUtilidades.W83bUtilidadesComunes;
import w83b.w83bUtilidades.W83bUtilidadesExcel;
import w83b.w83bUtilidadesComunes.W83bClsConstantes;
import es.ejie.frmk.infraestructura.internacionalizacion.Q70GestorMensajesi18n;
import es.ejie.frmk.listeners.base.Q70ListenerUtils;
import es.ejie.frmk.presentacion.operacion.paso.Q70ActionPasoOP;
import es.ejie.frmk.presentacion.sesiondatos.Q70ContextoEJIE;

// TODO: Auto-generated Javadoc
/**
 * The Class W83bTablaConveniosOP.java.
 *
 * @author Deusto Sistemas
 */
public class W83bTablaArbitrosExcelAction extends Q70ActionPasoOP{


	/**
	 * processOP.
	 *
	 * @param contexto a
	 * @param errores a
	 * @param mapping a
	 * @param form a
	 * @param request a
	 * @param response a
	 * @throws Exception e
	 */	
	protected void processOP(Q70ContextoEJIE contexto, ActionErrors errores, ActionMapping mapping,
			ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
		
		
	}

	/**
	 * processForward.
	 *
	 * @param contexto a
	 * @param errors a
	 * @param mapping a
	 * @param form a
	 * @param request a
	 * @param response a
	 * @return ActionForward
	 * @throws Exception e
	 */	
	protected ActionForward processForward(Q70ContextoEJIE contexto, ActionErrors errors, ActionMapping mapping, 
			ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {

		String strRutaExcel = Q70ListenerUtils.getApplicationProperty("RUTA_PLANTILLAS_EXCEL")+"plantillaExcelw83bListadoArbitros.xls";
		InputStream inputStream = W83bTablaArbitrosExcelAction.class.getResourceAsStream(strRutaExcel);
		HSSFWorkbook wb = new HSSFWorkbook(inputStream); // Creacin del libro
		wb.setSheetName(0,"Hoja1"); // Creacin de la hoja
        HSSFSheet sheet = wb.getSheetAt(0); // Creacin de la hoja
        
        List listaArbitros = (ArrayList)contexto.get("w83bListaArbitros");
        W83bArbitrosBean arbitrosBean = (W83bArbitrosBean)contexto.get("w83bArbitrosTempBean");         
        
        
        W83bUtilidadesExcel excel = new W83bUtilidadesExcel(wb);  

        W83bUsuarioXLNetsBean usuario = (W83bUsuarioXLNetsBean)contexto.get(W83bClsConstantes.CONSTANTE_CONTEXTO_USUARIO);  
        
        String idioma = (String)contexto.get(W83bClsConstantes.CONSTANTE_CONTEXTO_IDIOMA);  
        
        W83bUtilidadesExcel.crearCabeceraPieEstandar(sheet, idioma,(W83bUsuarioXLNetsBean)contexto.get(W83bClsConstantes.CONSTANTE_CONTEXTO_USUARIO));  
        HashMap mapaArbitros=  W83bUtilidadesComunes.obtenerTitulosDelegacionDepartamento(usuario,idioma);  
        
        HSSFRow row = sheet.createRow((short)1); // Creacin de la fila 1  
        HSSFCell cell = row.createCell((short)3);  
        row = sheet.getRow((short)4);  
        cell = row.getCell((short)2);  
        
        StringBuffer tituloImagenEs = (StringBuffer)mapaArbitros.get("tituloDepEs");  
        StringBuffer tituloImagenEu =  (StringBuffer)mapaArbitros.get("tituloDepEu");  
        cell.setCellValue(tituloImagenEu.toString());  
        
        cell = row.getCell((short)6);  
        cell.setCellValue(tituloImagenEs.toString());  
        
        tituloImagenEs = (StringBuffer)mapaArbitros.get("tituloDelelegacionEs");  
        tituloImagenEu = (StringBuffer)mapaArbitros.get("tituloDelelegacionEu");  

        row = sheet.getRow((short)6);  
        cell = row.getCell((short)2);  
        cell.setCellValue(tituloImagenEu.toString());  
        
        cell = row.getCell((short)6);  
        cell.setCellValue(tituloImagenEs.toString());  
        
        row = sheet.getRow((short)9);  
        cell = row.getCell((short)0);  
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.arbitros.listado").toUpperCase());  
        
        //MAPEO FORMULARIO
        row = sheet.getRow(Short.parseShort("12")); 
        cell = row.getCell(Short.parseShort("1"));
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.arbitros.territorio"));
        cell = row.createCell(Short.parseShort("3"));
        if(!StringUtils.isEmpty(arbitrosBean.getNombreTerritorio(arbitrosBean.getTerritorio()))){
        	sheet.addMergedRegion(new Region(W83bClsConstantes.DOCE,Short.parseShort("3"),W83bClsConstantes.DOCE,Short.parseShort("4")));//NOPMD
	        cell.setCellValue(arbitrosBean.getNombreTerritorio(arbitrosBean.getTerritorio()));
	        cell.setCellStyle(this.estiloFilaJustificado(W83bClsConstantes.DOCE,excel,wb));
        }else{
        	cell.setCellValue("");
        }
        
        cell = row.getCell(Short.parseShort("6"));
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.herramientas.baja"));
        cell = row.createCell(Short.parseShort("8"));
        if (StringUtils.isEmpty(arbitrosBean.getBaja())||W83bClsConstantes.ALTA.equals(arbitrosBean.getBaja())){
        	cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.herramientas.no",idioma).toUpperCase());

        }else{
        	cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.herramientas.si",idioma).toUpperCase());

        }
        cell.setCellStyle(this.estiloFilaJustificado(W83bClsConstantes.DOCE,excel,wb));
        
        row = sheet.getRow(Short.parseShort("13")); 
        cell = row.getCell(Short.parseShort("1"));
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.arbitros.dni"));
        cell = row.createCell(Short.parseShort("3"));
        if(StringUtils.isNotEmpty(arbitrosBean.getDni())){
	        cell.setCellValue(arbitrosBean.getDni());
	        cell.setCellStyle(this.estiloFilaJustificado(W83bClsConstantes.TRECE,excel,wb));
        }else{
        	cell.setCellValue("");
        }
        
        cell = row.getCell(Short.parseShort("6"));
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.arbitros.nombreArbitro"));
        cell = row.createCell(Short.parseShort("8"));
        if(StringUtils.isNotEmpty(arbitrosBean.getNombreArbitro())){
        	sheet.addMergedRegion(new Region(W83bClsConstantes.TRECE,Short.parseShort("8"),W83bClsConstantes.TRECE,Short.parseShort("11")));//NOPMD
        	cell.setCellValue(arbitrosBean.getNombreArbitro().toUpperCase());
        	cell.setCellStyle(this.estiloFilaJustificado(W83bClsConstantes.TRECE,excel,wb));
        }else{
        	cell.setCellValue("");
        }


        //Creamos la cabecera de la tabla
        //El ancho de las columnas se han hallado con la formula (20*tamnyo columna en chars)/(1/20)
        row = sheet.getRow(Short.parseShort("16")); // Creacin de la fila 1
        cell = row.getCell(Short.parseShort("0")); // Creacin de la columna 1 para la fila 1
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.arbitros.territorio"));
        
        cell = row.getCell(Short.parseShort("1")); // Creacin de la columna 2 para la fila 1
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.arbitros.dni"));
        
        cell = row.getCell(Short.parseShort("6")); // Creacin de la columna 3 para la fila 1
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.arbitros.nombreArbitro"));
        
        String pCod = "";//NOPMD
        for(int i=0;i<listaArbitros.size();i++){
        	row = sheet.createRow((short)W83bClsConstantes.DIECISIETE+i); // Creacin de la fila 1//NOPMD
        	
        	//Territotio
        	cell = row.createCell(Short.parseShort("0"));
        	W83bArbitrosBean arbBean = (W83bArbitrosBean) listaArbitros.get(i);
        	pCod = arbBean.getNombreTerritorio(arbBean.getTerritorio());
        	cell.setCellValue(pCod);
        	cell.setCellStyle(this.estiloFilaNumeroCentrado(i,excel));
        	
        	//dni
        	cell = row.createCell(Short.parseShort("1"));
        	sheet.addMergedRegion(new Region(W83bClsConstantes.DIECISIETE+i,Short.parseShort("1"),W83bClsConstantes.DIECISIETE+i,Short.parseShort("5")));//NOPMD
        	if(StringUtils.isNotEmpty(((W83bArbitrosBean)listaArbitros.get(i)).getDni())){
        		cell.setCellValue(((W83bArbitrosBean)listaArbitros.get(i)).getDni());
        	}else{
        		cell.setCellValue("");
        	}
        	
        	cell.setCellStyle(this.estiloFila(i,excel));
        	cell = row.createCell(Short.parseShort("2")); 
        	cell.setCellStyle(this.estiloFila(i,excel));
        	cell = row.createCell(Short.parseShort("3")); 
        	cell.setCellStyle(this.estiloFila(i,excel));
        	cell = row.createCell(Short.parseShort("4")); 
        	cell.setCellStyle(this.estiloFila(i,excel));
        	cell = row.createCell(Short.parseShort("5")); 
        	cell.setCellStyle(this.estiloFila(i,excel));
        	
        	//nombreArbitro
        	cell = row.createCell(Short.parseShort("6"));
        	sheet.addMergedRegion(new Region(W83bClsConstantes.DIECISIETE+i,Short.parseShort("6"),W83bClsConstantes.DIECISIETE+i,Short.parseShort("11")));//NOPMD
        	if(StringUtils.isNotEmpty(((W83bArbitrosBean)listaArbitros.get(i)).getNombreArbitro())){
        		cell.setCellValue(((W83bArbitrosBean)listaArbitros.get(i)).getNombreArbitro());
        	}else{
        		cell.setCellValue("");
        	}
        	
        	cell.setCellStyle(this.estiloFila(i,excel));
        	
        	cell = row.createCell(Short.parseShort("7")); 
        	cell.setCellStyle(this.estiloFila(i,excel));
        	cell = row.createCell(Short.parseShort("8")); 
        	cell.setCellStyle(this.estiloFila(i,excel));
        	cell = row.createCell(Short.parseShort("9")); 
        	cell.setCellStyle(this.estiloFila(i,excel));
        	cell = row.createCell(Short.parseShort("10")); 
        	cell.setCellStyle(this.estiloFila(i,excel));
        	cell = row.createCell(Short.parseShort("11")); 
        	cell.setCellStyle(this.estiloFila(i,excel));
        	if(StringUtils.isNotEmpty(((W83bArbitrosBean)listaArbitros.get(i)).getNombreArbitro())){        		
	        	if(73<((W83bArbitrosBean)listaArbitros.get(i)).getNombreArbitro().length()){
		    		row.setHeightInPoints((short)(20*((((W83bArbitrosBean)listaArbitros.get(i)).getNombreArbitro()).length()/73)+1));
		    	}
        	}
        }
        
		
        byte[] bytesExcel = W83bUtilidadesExcel.fncExcelToBytes(wb);
        
        response.setContentType("application/vnd.ms-excel");
        response.setContentLength(bytesExcel.length);
        response.setHeader("Content-disposition","attachment;filename=listadoArbitros.xls");
        response.getOutputStream().write(bytesExcel);
        response.getOutputStream().flush();

		
		return null;
	}
	
	/**
	 * Estilo fila.
	 * 
	 * @param nFila the n fila
	 * @param excel the excel
	 * @return the hSSF cell style
	 */
	private HSSFCellStyle estiloFila(int nFila, W83bUtilidadesExcel excel){
		if(nFila%2==0){
			return excel.styleTextoPar;//NOPMD
		}else{
			return excel.styleTextoImpar;			
		}
		
	}
	
	/**
	 * Estilo fila numero centrado.
	 *
	 * @param nFila the n fila
	 * @param excel the excel
	 * @return the hSSF cell style
	 */
	private HSSFCellStyle estiloFilaNumeroCentrado(int nFila, W83bUtilidadesExcel excel){
		if(nFila%2==0){
			return excel.styleTextoParNumeroCentrado;//NOPMD
		}else{
			return excel.styleTextoImparNumeroCentrado;			
		}
	}
	
	/**
	 * Estilo fila justificado.
	 *
	 * @param nFila the n fila
	 * @param excel the excel
	 * @param wb the wb
	 * @return the hSSF cell style
	 */
	private HSSFCellStyle estiloFilaJustificado(int nFila, W83bUtilidadesExcel excel, HSSFWorkbook wb){
		return excel.styleFilaJustificado;
	}
}
